/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.util;

import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Positioning;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class MountingHelper {
    protected final ComponentSink sink;
    protected final List<ModComponent> lateChildren;
    protected final Size childSpace;

    protected MountingHelper(ComponentSink sink, List<ModComponent> children, Size childSpace) {
        this.sink = sink;
        this.lateChildren = children;
        this.childSpace = childSpace;
    }

    public static MountingHelper mountEarly(ComponentSink sink, List<ModComponent> children, Size childSpace, Consumer<ModComponent> layoutFunc) {
        ArrayList<ModComponent> lateChildren = new ArrayList<ModComponent>();
        for (ModComponent child : children) {
            if (((Positioning)child.positioning().get()).type != Positioning.Type.RELATIVE) {
                sink.accept(child, childSpace, layoutFunc);
                continue;
            }
            lateChildren.add(child);
        }
        return new MountingHelper(sink, lateChildren, childSpace);
    }

    public void mountLate() {
        for (ModComponent child : this.lateChildren) {
            this.sink.accept(child, this.childSpace, component -> {
                throw new IllegalStateException("A layout-positioned child was mounted late");
            });
        }
        this.lateChildren.clear();
    }

    public static interface ComponentSink {
        public void accept(@Nullable ModComponent var1, Size var2, Consumer<ModComponent> var3);
    }
}

